<?php
/**
    * Plugin Name: Noropay-Woocommerce Addon
    * Plugin URI : https://noropay.com/test
    * Description: Noropay
    * Version: 1.0.0
    * Author: Noropay
    * Author URI: https://noropay.com/test
    * License: GPL2
    * License URI: https://www.gnu.org/licenses/gpl-2.0.html
    * Text Domain: paymoney-woocommerce-addon
    * Domain Path: /languages
*/

define('PAYMONEY_WOOCOMMERCE_ADDON_DIR', trailingslashit(plugin_dir_path( __FILE__ )));
define('PAYMONEY_WOOCOMMERCE_BRAND', 'Noropay');
!defined('PAYMONEY_WOOCOMMERCE_BASE_URL') ? define('PAYMONEY_WOOCOMMERCE_BASE_URL','http://dev.noropay.com/test/') : false;

require_once  PAYMONEY_WOOCOMMERCE_ADDON_DIR . 'src/includes.php' ;

add_action( 'plugins_loaded', function() {

    load_plugin_textdomain( 'paymoney-woocommerce-addon', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
    if ( ! class_exists( 'WC_Payment_Gateway' ) ) return;

    include_once( 'src/Common/Paymoney_ProcessWoocommerceGateway.php' );
    new Paymoney_ProcessWoocommerceGateway();
});

add_action( 'init', function() {
    if ( isset( $_GET['paymoney_woocommerce_payment_gateway'] ) ) {
        WC()->payment_gateways();
        do_action( 'paymoney_check_woocommerce_payment_gateway' );
    }
});

add_filter( 'woocommerce_payment_gateways', function( $methods ) {
    $methods[] = 'Paymoney_ProcessWoocommerceGateway';
    return $methods;
});